/*     This example shows how Java can access scripts directly.           
/*     Different scripting languages (e.g. Javascript, ooRexx)   	   
/*     		create a Java GUI within the script by using BSF.  	   
/*     To start: 1. cmd.exe/shell:  java TestScript "script filename"	   	 
/*      	  2. create new instance: = new ScriptInterpreter(filename) 
/***************************************************************************/

import java.awt.*;
import java.awt.*;
import java.io.*;

import org.apache.bsf.*;
import org.apache.bsf.util.*;

public class ScriptInterpreter {

public static String scriptName;

  /* class constructor uses BSF to (evaluate and) launch a script  
  /************************************************************/
  public ScriptInterpreter(String scriptName) throws BSFException {
  	
    // execute script
    try {
      BSFManager bsf = new BSFManager();
	  
	  //create "Java-String"
	  String btnLabel = "Label stammt aus Java";
      bsf.declareBean("btnLabel", btnLabel, String.class);
	  
      String language = BSFManager.getLangFromFilename(scriptName);
      FileReader in = new FileReader(scriptName);
      String script = IOUtils.getStringFromReader(in);
          
	  // launch script start  
      bsf.exec (language, scriptName, 0, 0, script);
      
    } 
	catch (BSFException e) { e.getMessage (); e.printStackTrace (); } 
	catch (IOException e)  { e.getMessage (); e.printStackTrace (); }
  }

  /* main() checks arguments (filename) and calls constructor    
  /***********************************************************/
  public static void main (String[] args) throws Exception {
  
     if (args.length == 0) {
	  scriptName = "frame.js";
      System.out.println ("Kein Skript uebergeben --> default: JavaScript "+scriptName);       
    } 
	else {
	  scriptName = args[0];
      System.out.println ("Skript erfolgreich uebergeben --> "+args[0]); 
	  if (args.length > 1) System.out.println ("Error: Es kann hchstens ein Parameter bergeben werden");
    } 
		
    // initialize TestScript
    new ScriptInterpreter(scriptName);
  }
}
